# 시험정리

- 접근지정자

  - `public` : 클래스의 내부/외부 모든 곳에서 접근할 수 있다.

  - `protected` : 클래스의 외부에서는 접근할 수 있지만, 파생 클래스에서 접근이 가능

  - `private` : 클래스의 내부에서만 접근할 수 있다.

  - `internal` : 같은 어셈블리에 있는 코드에 대해서만 public으로 접근, 다른 어셈블리에서는 private와 같은 수준

  - `protected internal` : 같은 어셈블리에 있는 코드에서 protected에서 접근, 다른 어셈블리에서 private와 같은 수준

- 생성자

  - 이름은 클래스 이름과 같다

  - 반환형을 선언하지 않는다

  - `new()` 키워드를 통해 인스턴스(객체)화 될 때 호출된다

  - 일반적으로 객체의 변수를 초기화 할 때 사용한다

  - 개발자가 직접 정의하지 않아도 된다

  - 일반적으로 `public` 접근지정자를 사용하나, `private`를 사용하기도 한다

- 소멸자

  - `~`기호를 붙인다

  - 접근 지정자를 사용하지 않는다

  - 반환과 관련된 선언을 하지 않는다

  - 매개변수와 관련된 선언을 하지 않는다

- 상속

  자식 객체를 생성하면, 부모 생성자도 자동으로 호출된다.

  `base()`를 적지 않아도 되는데, `base`에 만약 인자값이 필요하면 명시적으로 적어줘야 한다.

  ```csharp
  public Child : Parent
  {
      public Child() base() // 부모생성자 실행
      {
          Console.WriteLine("자식생성자");
      }
  }
  ```

- `ref`

  참조에 의한 매개 변수 전달 (call by reference)

  결과를 저장하지 않아도 오류 안남

- `out`

  출력 전용 매개 변수

  - 함수 내에서 `out` 키워드가 붙은 인자를 설정해줘야한다. 안하면 오류

- `is`는 동일한 객체라면 `true`

  ```csharp
  car is Car // true
  ```

- `as`는 형변환

  ```csharp
  supercar as Car
  ```

- 오버라이딩과 오버로딩 외워놓자

- 인터페이스 (`interface`)

  - `interface` 키워드를 사용

  - 메서드, 이벤트, 인덱서, 프로퍼티(속성)을 가질 수 있는데 구현부는 없다

  - 필드는 가질 수 없다

  - 다중 상속이 가능하다

  - 인스턴스를 만들 수 없다. 상속받은 클래스의 인스턴스는 가능

  - `public`으로 선언된다.

- 추상클래스 (`abstract`)

  - 인터페이스와 달리 구현을 가질 수 없다

  - 클래스와는 달리 인스턴스를 만들 수 없다

  - 추상 메소드를 가질 수 있다(파생 클래스에서 구현 강제)
